//=============================================================================
// GreaselPet.
//=============================================================================
class HALPAgent2 extends DeusExPickup;

var localized String MsgNoHALP;

state Activated
{
	function Activate()
	{
	}

	function BeginState()
	{
		local DeusExPlayer P;
                		local Vector loc;
		local HALPCompanion2 D;
	
		Super.BeginState(); 

                		P = DeusExPlayer(Owner);
                		if ( P != None )    
                		{            
                      		D = Spawn(Class'HALPCompanion2',P,,P.Location + (P.CollisionRadius+Class'DragonCompanion'.Default.CollisionRadius+30) * Vector(P.ViewRotation) + vect(0,0,1) * 30 );
			if ( D != None )
			{
                      			D.PlaySound(None);
                      			UseOnce();
			}
			else
			{
				P.ClientMessage(MsgNoHALP);
				GotoState('DeActivated');
			}
                		}
	}
Begin:
}

defaultproperties
{
     MsgNoHALP="|p2HALP agent cannot be released here."
     bActivatable=True
     ItemName="Inactive HALP agent"
     PlayerViewOffset=(X=20.000000,Z=-12.000000)
     PlayerViewMesh=LodMesh'DeusExCharacters.SpiderBot2'
     PlayerViewScale=0.400000
     PickupViewMesh=LodMesh'DeusExCharacters.SpiderBot2'
     PickupViewScale=0.500000
     ThirdPersonMesh=LodMesh'DeusExCharacters.SpiderBot2'
     ThirdPersonScale=0.500000
     LandSound=Sound'DeusExSounds.Generic.MetalHit1'
     Icon=Texture'Markistan.Icons.BeltIconHALPAgent'
     largeIcon=Texture'Markistan.Icons.InventoryIconHALPAgent'
     largeIconWidth=49
     largeIconHeight=49
     Description="A new technology known as the HALP agent, it is a robotic H.eavily A.rmed L.ightweight P.rotectant, you simply release it, and it will protect you."
     beltDescription="HALP"
     Mesh=LodMesh'DeusExCharacters.SpiderBot2'
     DrawScale=0.5
     CollisionRadius=16.790001
     CollisionHeight=7.620000
     Mass=50.000000
     Buoyancy=100.000000
     Skin=Texture'Markistan.Skins.MarkistanBotTex2'
}
